<?php if (!defined('ABSPATH')) exit;
	
	global $translation_array;
	
	$translation_array = array('file_upload_remarks'=>'');

	function wevp_admin_scripts()
	{
		global $translation_array;


//		wp_enqueue_script('wevp-boostrap-script', plugins_url('js/bootstrap.js', dirname(__FILE__)), array('jquery'), '1.0', true);
//		wp_enqueue_style('wevp-boostrap-style', plugins_url('css/bootstrap.css', dirname(__FILE__)));

	
		wp_register_style('wevp-admin', plugins_url('css/admin-style.css?t=' . time(), dirname(__FILE__)));
	
	
		wp_enqueue_style('wevp-admin');
	
		wp_enqueue_script(
			'wevp_scripts',
			plugins_url('js/admin-scripts.js', dirname(__FILE__)),
			array('jquery'),
			time()
		);
	
		$translation_array['this_url'] = admin_url('admin.php?page=wevp_settings');
		$translation_array['wevp_tab'] = (isset($_GET['t']) ? $_GET['t'] : '0');
		$translation_array['is_product_variable'] = is_product_variable();
		$translation_array['select_alert'] = __('Please select a file to import.', 'woo-evp');


	
	
		wp_localize_script('wevp_scripts', 'var_import_export', $translation_array);

	}

	if(!function_exists('wevp_sanitize_data')){
		function wevp_sanitize_data( $input ) {
			if(is_array($input)){		
				$new_input = array();	
				foreach ( $input as $key => $val ) {
					$new_input[ $key ] = (is_array($val)?wevp_sanitize_data($val):sanitize_text_field( $val ));
				}			
			}else{
				$new_input = sanitize_text_field($input);			
				if(stripos($new_input, '@') && is_email($new_input)){
					$new_input = sanitize_email($new_input);
				}
				if(stripos($new_input, 'http') || wp_http_validate_url($new_input)){
					$new_input = esc_url_raw($new_input);
				}			
			}	
			return $new_input;
		}	
	}		
	
	if (!function_exists('wevp_pre')) {
		function wevp_pre($data)
		{
			if (isset($_GET['debug'])) {
				wevp_pree($data);
			}
		}
	}
	if (!function_exists('wevp_pree')) {
		function wevp_pree($data)
		{
			echo '<pre>';
			print_r($data);
			echo '</pre>';
		}
	}
	
	
	
	
	function wevp_admin_menu()
	{
		global $wevp_data;
	
		$title = str_replace('WooCommerce', 'WC', $wevp_data['Name']);
		add_submenu_page('woocommerce', $title, __('Export Variable Products', 'woo-evp'), 'manage_woocommerce', 'wevp_settings', 'wevp_settings');
	}
	
	function wevp_settings()
	{

	    global $wevp_dir;
	
	
		if (!current_user_can('administrator')) {
	
	
	
			wp_die(__('You do not have sufficient permissions to access this page.', 'woo-evp'));

		}else{

            include_once ($wevp_dir.'/inc/admin_settings.php');

        }
	
	
	
		global $wpdb;
	}
	
	
	function wevp_plugin_linx($links)
	{
	
		global $wevp_premium_copy, $wevp_pro;
	
	
		$settings_link = '<a href="admin.php?page=wevp_settings">' . __('Settings', 'woo-evp') . '</a>';
	
	
		if ($wevp_pro) {
			array_unshift($links, $settings_link);
		} else {
	
			$wevp_premium_link = '<a href="' . $wevp_premium_copy . '" title="' . __('Go Premium', 'woo-evp') . '" target="_blank">' . __('Go Premium', 'woo-evp') . '</a>';
			array_unshift($links, $settings_link, $wevp_premium_link);
		}
	
	
		return $links;
	}
	
	
	function wevp_array_unique_recursive($array)
	{
		$array = array_unique($array, SORT_REGULAR);
	
		foreach ($array as $key => $elem) {
			if (is_array($elem)) {
				$array[$key] = wevp_array_unique_recursive($elem);
			}
		}
	
		return $array;
	}
	
	
	if (!function_exists('wevp_fetch_array')) {
		function wevp_fetch_array($result)
		{
			return json_decode(json_encode($result), true);
		}
	}
	

	
	
	
	function wevp_admin_head()
	{
		global $wevp_url;
	
	?>
	
		<style type="text/css">
			li.current a[href="admin.php?page=wevp_settings"],
			li.current a[href="admin.php?page=wevp_settings"]:hover {
				background-color: #32373C !important;
				color: #fff !important;
				background-image: url("<?php echo $wevp_url; ?>img/woo.png?<?php echo time(); ?>") !important;
				background-size: 18px !important;
				background-repeat: no-repeat !important;
				background-position: 4px 10px !important;
				text-indent: 14px !important;
				font-size: 12px !important;
			}
	
			li.current a[href="admin.php?page=wevp_settings"]:hover {
				background-color: #32373C !important;
				color: #fff !important;
			}
	
			@media only screen and (max-device-width: 480px) {}
	
			/* ipad */
			@media only screen and (min-device-width : 768px) and (max-device-width : 1024px) {}
	
			@media all and (-ms-high-contrast: none),
			(-ms-high-contrast: active) {}
	
			@supports (-ms-accelerator:true) {
				/* IE Edge 12+ CSS styles go here */
			}
		</style>
		<script type="text/javascript" language="javascript">
			jQuery(document).ready(function($) {
				<?php if (isset($_GET['mt']) && isset($_GET['post'])) : ?>
					if ($('.woocommerce-order-data__heading').length > 0) {
						$('.woocommerce-order-data__heading').html('Order #<?php echo wevp_sanitize_data($_GET['mt']); ?>');
					}
				<?php endif; ?>
			});
		</script>
	<?php
	
	}
	
	add_action('admin_head', 'wevp_admin_head');
	
	
	
	function wevp_get_product_attr($product)
	{
		$attributes = array_filter($product->get_attributes(), 'wc_attributes_array_filter_visible');
		$values = array();
		foreach ($attributes as $attribute) {
	
			if ($attribute->is_taxonomy()) {
				$attribute_values   = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));
				foreach ($attribute_values as $attribute_value) {
	
					$values[$attribute_value->taxonomy][] = $attribute_value->slug;
				}
			} else {
				$attr_values = $attribute->get_options();
				foreach ($attr_values as $value) {
					$values[$attribute->get_name()][] = $value;
				}
			}
		}
		return ($values);
	}
	
	add_action("init", "wevp_export_data_function");
	add_action("init", "wevp_import_product_variations");
	
	if (!function_exists("wevp_export_data_function")) {
		function wevp_export_data_function()
		{
	
			//pree($_POST);exit;
			if (isset($_POST['export_product_id'])) {
	
				if (!isset($_POST['export_file_nonce_field']) || !wp_verify_nonce($_POST['export_file_nonce_field'], 'export_file_nonce_action')) {
					print __('Sorry, your nonce did not verify.', 'woo-evp');
					exit;
				} else {
	
	
					if (!class_exists('XLSXWriter')) {
						$xlsxwriter = WEVP_PLUGIN_DIR . '/inc/xlsxwriter.class.php'; //exit;
						if (file_exists($xlsxwriter)) {
							//echo 
							include_once($xlsxwriter);
							//exit;
						}
					} else {
						//echo 'XLSXWriter';exit;
					}
	

					//pree($_POST);exit;
	
	
					if (class_exists('XLSXWriter')) {
	
						if (class_exists('ZipArchive')) {
	
							$parent_product_id = $_POST['export_product_id'];
							$parent_product =  wc_get_product($parent_product_id);
	
							// $parent_product->list_attributes();
							$default_attr = array();
							$default_attr = wevp_get_product_attr($parent_product);
	
							$child_products = $parent_product->get_children();
	
							$export_column = array(
								'parent_id' => '',
								'id' => '',
								'slug' => '',
								'sku' => '',
								// 'price' => '',
								'regular_price' => '',
								'sale_price' => '',
								// 'manage_stock' => '',
								// 'stock_quantity' => '',
								// 'stock_status' => '',
								// 'backorders' => '',
								'weight' => '',
								'length' => '',
								'width' => '',
								'height' => '',
							);
	
							if (!empty($child_products)) {
	
								$export_data = array();
	
								foreach ($child_products as $child_id) {
									# code...
	
									$var_product = wc_get_product($child_id);
									$var_product_data = $var_product->get_data();
									$var_attributes = $var_product_data['attributes'];
									$export_column = array_merge($export_column, $var_attributes);
	
	
									$export_child_data = array_intersect_key($var_product_data, $export_column);
									// $export_child_data['manage_stock'] = ($export_child_data['manage_stock'] == 1)?'true':'false'; 
									$export_data[] = array_merge($export_column, $export_child_data);
								}
	
	
								ob_clean();
								$filename = $parent_product_id . "_product_variations.xlsx";
								header('Content-disposition: attachment; filename="' . XLSXWriter::sanitize_filename($filename) . '"');
								header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
								header('Content-Transfer-Encoding: binary');
								header('Cache-Control: must-revalidate');
								header('Pragma: public');
	
								$header = array();
								if (!empty($export_column)) {
									foreach ($export_column as $key => $value) {
										$header[$key] = 'string';
									}
								}
	
	
	
								$writer = new XLSXWriter();
	
	
								$writer->writeSheetHeader('Sheet1', $header);
								foreach ($export_data as $row) {
									$writer->writeSheetRow('Sheet1', $row);
								}
								$writer->writeToStdOut();
								exit;
							}
						} else {
							_e('PHP Class ZipArchive is missing. Please check it with your hosting server settings.', 'woo-evp');
						}
					}
				}
			}
		}
	}
	
	if (!function_exists("wevp_import_product_variations")) {
	
		function wevp_import_product_variations()
		{
			global $translation_array;
			$success = array();
			$error = array();
	
			if (isset($_FILES['variation_file']) && isset($_POST['file_submit'])) {
	
				if (!isset($_POST['import_file_nonce_field']) || !wp_verify_nonce($_POST['import_file_nonce_field'], 'import_file_nonce_action')) {
					print __('Sorry, your nonce did not verify.', 'woo-evp');
					exit;
				} else {
					
					$upload = wp_upload_bits($_FILES["variation_file"]["name"], null, file_get_contents($_FILES["variation_file"]["tmp_name"]));
	
					if (!class_exists('SimpleXLSX')) {
						$SimpleXLSX = WEVP_PLUGIN_DIR . '/inc/SimpleXLSX.php'; //exit;
						if (file_exists($SimpleXLSX)) {
							//echo 
							include_once($SimpleXLSX);
							//exit;
						}
					} else {
						//echo 'XLSXWriter';exit;
					}
						
					if (class_exists('SimpleXLSX') && $xlsx = SimpleXLSX::parse($upload['file'])) {
	
						$rows = $xlsx->rows();
	
						if (!empty($rows)) {
							$headings_row = $rows[0];
							$var_product_data = array();
							foreach ($rows as $key => $row) {
								if ($key == 0) continue;
								$var_product_data[] = array_combine($headings_row, $row);
								# code...
							}
	
							if (!empty($var_product_data)) {
								$row = 1;
								foreach ($var_product_data as $key => $value) {
									# code...
									$parent_id = $value['parent_id'];
	
									$var_product_id = $value['id'];
									if ($parent_id != $_POST['file_submit'] || empty($parent_id)) {
										$error[$parent_id][] = array('row' => $row,  'status' => 'failed', 'remarks' => ''.__('Parent id different or empty', 'woo-evp'));
										$row++;
										continue;
									}
									$var_parent_product = wc_get_product($parent_id);
									$var_child_products = $var_parent_product->get_children();
	
									$product_default_attr = wevp_get_product_attr($var_parent_product);
									$product_default_attr = array_change_key_case($product_default_attr);
	
									if (empty($var_product_id) || !in_array($var_product_id, $var_child_products)) {
										$error['empty or wrong'][] = array('row' => $row,  'status' => 'failed', 'remarks' => __('Variation id empty or not belong to current product', 'woo-evp'));
										$row++;
										continue;
									}
	
									$var_product = wc_get_product($var_product_id);
									$var_product_data = $var_product->get_data();
									$attributes = array_keys($var_product_data['attributes']);
									$skip_array = array('parent_id', 'id');
									$post_table = array('slug', 'name');
									
									//pree($var_product->get_slug() .'!='. $value['slug']);exit;
									
									if ($var_product->get_slug() != $value['slug']) {
										$args = array(
											'ID' => $var_product_id,
											'post_name' => $value['slug'],
										);
	
										$update_post = wp_update_post($args);
										if ($update_post != $var_product_id) {
											$error[$var_product_id . '_' . $value['slug']][] = array('row' => $row, 'slug' => $value['slug'], 'status' => 'failed', 'remarks' => '');
										}
									}
	
	
									if (!empty($value)) {
										$col = 1;
										foreach ($value as $product_key => $product_value) {
											# code...
											if (in_array($product_key, $skip_array)) {
												$col++;
												continue;
											}
											if (!in_array($product_key, $attributes) && !in_array($product_key, $post_table)) {
	
												if (get_post_meta($var_product_id, '_' . $product_key, true) != $product_value) {
													$update_status = update_post_meta($var_product_id, '_' . $product_key, $product_value);
	
													if ($update_status == false) {
														$error[$var_product_id . '_' . $value['slug']][] = array('row' => $row, 'column' => $col, $product_key => $product_value, 'status' => 'failed', 'remarks' => '');
													}
												}
											}
											if (in_array($product_key, $attributes)) {
												
												$product_key_with_space = str_replace(array('-'), ' ', $product_key);
												 
												/*pree($product_key);
												pree($product_default_attr);
												pree($product_value);
												pree($product_default_attr[$product_key]);
												pree($product_value);*/
												//pree(isset($product_default_attr[$product_key]) && in_array(strtolower($product_value), array_map('strtolower', $product_default_attr[$product_key])) || empty($product_value));
	
												//pree($product_key);
												//pree($product_key_with_space);
												//pree($product_default_attr);
												
												if (isset($product_default_attr[$product_key_with_space]) && in_array(strtolower($product_value), array_map('strtolower', $product_default_attr[$product_key_with_space])) || empty($product_value)) {
													
													$attribs = $var_product->get_attributes();
													
													//pree($product_key.' - '.$product_key_with_space);
													//pree($attribs);
													//pree($product_value);
	
													if (array_key_exists($product_key, $attribs) && $attribs[$product_key] != $product_value) {
														$attr_status = update_post_meta($var_product_id, 'attribute_' . $product_key, $product_value);
														//pree($attr_status?'Success':'Failure');
														if ($attr_status == false) {
															$error[$var_product_id . '_' . $value['slug']][] = array('row' => $row, 'column' => $col, $product_key => $product_value, 'status' => 'failed', 'remarks' => '');
														}
													}else{
														
													}
												} else {
													$error[$var_product_id . '_' . $value['slug']][] = array('row' => $row, 'column' => $col, $product_key => $product_value, 'status' => 'failed', 'remarks' => __('Provided attribute not matched with defined attributes', 'woo-evp'));
												}
											}
											$col++;
										}
									}
	
									$row++;
								}
							}
						}
						
						//pree($error);exit;
						$error_log = array();
						if (!empty($error)) {
							
							foreach ($error as $key => $value) {
								# code...
								$error_log[] = "\t \t" . json_encode($key) . "\n \n";
								if (!empty($value)) {
									foreach ($value as $inner_key => $inner_value) {
										# code...
										$error_log[] = json_encode($inner_value) . "\n \n";
									}
								}
							}
						}
						$upload_dir   = wp_upload_dir();
						//pree($upload_dir);exit;
						file_put_contents($upload_dir['basedir'].'/import-error-log.html', $error_log);
	
						if (sizeof($error) != 0) {
							$translation_array['file_upload_status'] = 'true';
							$translation_array['file_upload_remarks'] = __('Data updated with errors,', 'woo-evp').' <a href="'.$upload_dir['baseurl'].'/import-error-log.html" target="_blank">'.__('click here', 'woo-evp').'</a> '.__('to read errors.', 'woo-evp');
						} else {
	
							$translation_array['file_upload_status'] = 'true';
							$translation_array['file_upload_remarks'] = 'Data updated';
						}
	
					} else {
						$translation_array['file_upload_status'] = 'false';
						$translation_array['file_upload_remarks'] = SimpleXLSX::parseError();
					}
	
					if(file_exists($upload['file'])){
						unlink($upload['file']); 
					} 
	
				}
			}
		}
	}
	
	// add_action('wp_ajax_wevp_import_product_variations', 'wevp_import_product_variations');
	// add_action('wp_ajax_wevp_export_data_function', 'wevp_export_data_function');
	
	function is_product_variable()
	{
		global $post;
	
		if (is_object($post) && $post->post_type == 'product') {
	
			$product = wc_get_product($post->ID);
	
			if ($product->is_type('variable')) {
				return 'true';
			} else {
				return 'false';
			}
		} else {
			return 'false';
		}
	}
	
	
	/* Create one or more meta boxes to be displayed on the post editor screen. */
	function wevp_add_product_variations_meta_box()
	{
		global $post;
	
		if (is_object($post) && $post->post_type == 'product') {

			$product = wc_get_product($post->ID);

			if ($product->is_type('variable')) {
				add_meta_box(
					'product-variations-import-export',      // Unique ID
					__('Export/Import Product Data', 'woo-evp'),    // Title
					'wevp_product_variations_import_export_box',   // Callback function
					'product',         // Admin page (or post type)
					'side',         // Context
					'high'         // Priority
				);
			}
		}
	}
	
	/* Display the post meta box. */
	function wevp_product_variations_import_export_box()
	{
		global $post;
		
		$screen = get_current_screen();
		
		if ( $screen->parent_base != 'edit' || (is_object($post) && $post->post_type != 'product') ) {
			return;
		}
		if(!is_product_variable()){return;}



?>
		<div class="var-import-export-box d-none" style="display: inline">
	
			<input type="button" class="page-title-action import-action" value="<?php _e('Import', 'woo-evp'); ?>">
	
			<form class="export-file" method="post" style="display: inline">
				<input type="hidden" name="export_product_id" value="<?php echo $post->ID ?>">
				<input type="button" class="page-title-action export-btn" name="export_product" value="<?php _e('Export', 'woo-evp'); ?>">
				<?php wp_nonce_field('export_file_nonce_action', 'export_file_nonce_field'); ?>
			</form>
	
            
	
			<div class="row mt-3 col-md-12">
                
                
				<div class="col-md-12 col-12">				
					<div class="wevpt-import-file-box" style="display: none">
						<div class="card">
							<div class="card-header"><?php _e('Select variable product file', 'woo-evp') ?></div>
                            <form class="import-file" method="post" style="display: inline" enctype="multipart/form-data">
							<div class="card-body">
	
								
								
	
									<input type="file" class="variation_file" name="variation_file" required>
									<input type="hidden" name="file_submit" value="<?php echo $post->ID ?>">
									<?php wp_nonce_field('import_file_nonce_action', 'import_file_nonce_field'); ?>
	
							</div>
							<div class="card-footer">
									<input type="submit" class="button button-primary import-btn" name="file_submit" value="<?php _e('Import File', 'woo-evp'); ?>">
								
								
							</div>
                            </form>
						</div>
	
					</div>
	
	
	
	
	
				</div>
                
                
                
			</div>
            
            <div style="display:none; margin-top:18px;" class="notice notice-success is-dismissible file_upload_alert">
                <p>
               <strong><?php _e('Success', 'woo-evp') ?>!</strong><?php _e(' Product data imported successfully', 'woo-evp') ?>, <a target="_blank" href="<?php echo get_permalink($post->ID); ?>"><?php _e('click here', 'woo-evp') ?></a><?php  _e(' to view product.', 'woo-evp'); ?>
                </p>
            </div>
            
            <div style="display:none;" class="notice notice-warning is-dismissible">
                <p>
                    <strong><?php echo __('Warning!', 'woo-evp'); ?></strong> <span class="wevp_error"><?php _e('This alert box indicates a warning that might need attention.', 'woo-evp'); ?></span>
                </p>
            </div>

			
		</div>


	
	
		<!-- This Block Will Show when a file will uploaded -->


	
	
	
		</div>
	<?php 
	

	}
	
	add_action('admin_footer', 'wevp_product_variations_import_export_box');
		
//	 add_action('add_meta_boxes', 'wevp_add_product_variations_meta_box');
