<?php
/**
 * The post accordion template.
 *
 * @package easy_accordion_free
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

if ( empty( $content_sources ) ) {
	return;
}

if ( $acc_section_title ) {
	echo '<h2 class="eap_section_title eap_section_title_' . esc_attr( $post_id ) . '"> ' . wp_kses_post( $main_section_title ) . ' </h2>';
}

echo '<div id="' . esc_attr( $eap_accordion_uniq_id ) . '">';
echo '<div id="sp-ea-' . esc_attr( $post_id ) . '" class="' . esc_attr( $accordion_wrapper_class ) . '" data-ex-icon="' . esc_attr( $eap_expand_icon ) . '" data-col-icon="' . esc_attr( $eap_collapse_icon ) . '"  data-ea-active="' . esc_attr( $eap_active_event ) . '"  data-ea-mode="' . esc_attr( $accordion_layout ) . '" data-preloader="' . esc_attr( $eap_preloader ) . '" data-scroll-active-item="' . esc_attr( $eap_scroll_to_active_item ) . '" data-offset-to-scroll="' . esc_attr( $eap_offset_to_scroll ) . '">';
if ( $eap_preloader ) {
	echo '<div id="eap-preloader-' . esc_attr( $post_id ) . '" class="accordion-preloader">';
	echo '<img src="' . esc_url( SP_EA_URL . 'public/assets/ea_loader.svg' ) . '" alt="Loader image"/>';
	echo '</div>';
}
global $wp_embed;
$ea_key                         = 1;
$eapro_allowed_description_tags = eapro_allowed_description_tags();

foreach ( $content_sources as $key => $content_source ) {
	$content_title = $content_source['accordion_content_title'];
	$content       = apply_filters( 'sp_easy_accordion_content', $content_source['accordion_content_description'] );
	$content       = str_replace( ']]>', ']]&gt;', $content );
	if ( 'ea-first-open' === $eap_accordion_mode ) {
		$a_open_first      = ( 1 === $ea_key ) ? 'collapsed show' : '';
		$expand_icon_first = ( 1 === $ea_key ) ? $eap_expand_icon : $eap_collapse_icon;
		$expand_class      = ( 1 === $ea_key ) ? 'ea-expand' : '';
		$aria_expanded     = ( 1 === $ea_key ) ? 'true' : 'false';
	} elseif ( 'ea-multi-open' === $eap_accordion_mode ) {
		$a_open_first      = 'collapsed show';
		$expand_icon_first = $eap_expand_icon;
		$expand_class      = 'ea-expand';
		$aria_expanded     = 'true';
	} elseif ( 'ea-all-close' === $eap_accordion_mode ) {
		$a_open_first      = 'spcollapse';
		$expand_icon_first = $eap_collapse_icon;
		$expand_class      = '';
		$aria_expanded     = 'false';
	}
	$eap_exp_icon_markup = ( $eap_icon ) ? '<i class="ea-expand-icon ea-icon-expand-' . $expand_icon_first . '"></i> ' : '';
	$data_sptarget       = '#collapse' . $post_id . $key;
	$eap_icon_markup     = $eap_exp_icon_markup;

	// Start accordion card div.
	echo '<div class="ea-card ' . esc_attr( $expand_class . ' ' . $accordion_item_class ) . '">';

	// Start accordion header.
	echo '<h3 class="ea-header">';

	// Add anchor tag for header.
	echo '<a class="collapsed" id="ea-header-' . esc_attr( $post_id . $key ) . '" data-sptoggle="spcollapse" data-sptarget="' . esc_attr( $data_sptarget ) . '" aria-controls="collapse' . esc_attr( $post_id . $key ) . '" href="javascript:void(0)" ' . esc_attr( $nofollow_link_text ) . ' aria-expanded="' . esc_attr( $aria_expanded ) . '" tabindex="0">';

	// Add icon and title.
	echo wp_kses_post( $eap_icon_markup . $content_title );

	// Close anchor tag for header.
	echo '</a>';

	// Close header tag.
	echo '</h3>';

	// Start collapsible content div.
	echo '<div class="sp-collapse spcollapse ' . esc_attr( $a_open_first ) . '" id="collapse' . esc_attr( $post_id . $key ) . '" ' . ( ! $eap_mutliple_collapse ? 'data-parent="#sp-ea-' . esc_attr( $post_id ) . '"' : '' ) . ' role="region" aria-labelledby="ea-header-' . esc_attr( $post_id . $key ) . '">';

	// Content div.
	echo '<div class="ea-body">';
	if ( ! empty( $content ) ) {
		// Add escaping filter to the accordion content before autoembed and do_shortcode unless the shortcode scripts or few tags generated by shortcodes are removed by the filter.
		$content_to_embed = wp_kses( $content, $eapro_allowed_description_tags );
		$embedded_content = $wp_embed->autoembed( $content_to_embed );

		if ( $eap_autop ) {
			$embedded_content = wpautop( $embedded_content );
			// Remove empty p tags before and after shortcodes and then do_shortcode.
			echo do_shortcode( shortcode_unautop( $embedded_content ) );
		} else {
			echo do_shortcode( $embedded_content );
		}
	} else {
		echo esc_html__( 'No Content', 'easy-accordion-free' );
	}
	// Close content div.
	echo '</div>';

	// Close collapse div.
	echo '</div>';

	// Close card div.
	echo '</div>';
	++$ea_key;
}
if ( $eap_schema_markup ) {
	echo '<script type="application/ld+json">
	{
	  "@context": "https://schema.org",
	  "@type": "FAQPage",
	  "mainEntity": [';
	foreach ( $content_sources as $keys => $content_source ) {
		$content_title       = $content_source['accordion_content_title'];
		$content_description = $content_source['accordion_content_description'];
		echo '{
			"@type": "Question",
			"name": "' . esc_attr( wp_strip_all_tags( $content_title ) ) . '",
			"acceptedAnswer": {
			  "@type": "Answer",
			  "text": "' . esc_html( wp_strip_all_tags( strip_shortcodes( $content_description ) ) ) . '"
			}
		  }';
		if ( $keys !== $key ) {
			echo ',';
		}
	}
	echo ']
	}
	</script>';

}

echo '</div>';
echo '</div>';
